# blog/models.py
from django.db import models

class Post(models.Model):
    # 記事モデル: タイトルと本文、作成/更新日時
    title = models.CharField(max_length=200, verbose_name="タイトル")
    body = models.TextField(verbose_name="本文")
    created_at = models.DateTimeField(auto_now_add=True, verbose_name="作成日時")
    updated_at = models.DateTimeField(auto_now=True, verbose_name="更新日時")

    def __str__(self):
        # 管理画面などでの表示名
        return self.title